### Name: predprob.zeroinfl
### Title: Predicted probabilities from zero-inflated regression models
### Aliases: predprob.zeroinfl
### Keywords: models regression

### ** Examples

data(bioChemists)
zip <- zeroinfl(count=art ~ .,
                x = ~ fem + mar + kid5 + phd + ment,
                z = ~ fem + mar + kid5 + phd + ment,
                dist="poisson",        
                data=bioChemists,trace=TRUE) ## zero-infl poisson
phat <- predprob(zip)
newdata <- expand.grid(list(fem="Men",mar="Married",
                            kid5=1,phd=3.103,
                            ment=0:77))
phat <- predprob(zip,newdata=newdata)



