### Name: vuong
### Title: Vuong's non-nested hypothesis test
### Aliases: vuong
### Keywords: models

### ** Examples

data(bioChemists)
glm1 <- glm(art ~ .,
            data=bioChemists,
            family=poisson,trace=TRUE)  ## poisson GLM

zip <- zeroinfl(count=art ~ .,
                x = ~ fem + mar + kid5 + phd + ment,
                z = ~ fem + mar + kid5 + phd + ment,
                dist="poisson",        
                data=bioChemists,trace=TRUE) ## zero-infl poisson

vuong(glm1,zip)

## compare negbin with zero-inflated negbin
require(MASS)
nb1 <- glm.nb(art ~ .,
              data=bioChemists,
              trace=TRUE)
zinb <- zeroinfl(count=art ~ .,
                 x = ~ fem + mar + kid5 + phd + ment,
                 z = ~ fem + mar + kid5 + phd + ment,
                 dist="negbin",
                 data=bioChemists,trace=TRUE)
vuong(nb1,zinb)



