### Name: pvclust
### Title: Calculating P-values for Hierchical Clustering
### Aliases: pvclust parPvclust
### Keywords: cluster

### ** Examples

## using Boston data in package MASS
library(MASS)
data(Boston)

## multiscale bootstrap resampling
boston.pv <- pvclust(Boston, nboot=100)

## CAUTION: nboot=100 may be too small for actual use.
##          We suggest nboot=1000 or larger.
##          plot/print functions will be useful for diagnostics.

## plot dendrogram with p-values
plot(boston.pv)

ask.bak <- par()$ask
par(ask=TRUE)

## highlight clusters with high au p-values
pvrect(boston.pv)

## print the result of multiscale bootstrap resampling
print(boston.pv, digits=3)

## plot diagnostic for curve fitting
msplot(boston.pv, edges=c(2,4,6,7))

par(ask=ask.bak)

## Print clusters with high p-values
boston.pp <- pvpick(boston.pv)
boston.pp

## Not run: 
##D ## parallel computation via snow package
##D library(snow)
##D cl <- makeCluster(10, type="MPI")
##D 
##D ## parallel version of pvclust
##D boston.pv <- parPvclust(cl, Boston, nboot=1000)
## End(Not run)



