### Name: quantregForest
### Title: Quantile Regression Forests
### Aliases: quantregForest
### Keywords: regression tree

### ** Examples


################################################
##  Load air-quality data (and preprocessing) ##
################################################

data(airquality)
set.seed(1)

## remove observations with mising values
airquality <- airquality[ !apply(is.na(airquality), 1,any), ]

## number of remining samples
n <- nrow(airquality)

## divide into training and test data
indextrain <- sample(1:n,round(0.6*n),replace=FALSE)
Xtrain     <- airquality[ indextrain,2:6]
Xtest      <- airquality[-indextrain,2:6]
Ytrain     <- airquality[ indextrain,1]
Ytest      <- airquality[-indextrain,1]


################################################
##     compute Quantile Regression Forests    ##
################################################

qrf <- quantregForest(x=Xtrain, y=Ytrain)

## plot out-of-bag predictions for the training data
plot(qrf)

## compute out-of-bag predictions 
quant.outofbag <- predict(qrf)

## predict test data
quant.newdata  <- predict(qrf, newdata= Xtest)





