### Name: simpleRake
### Title: Perform a complete Raking
### Aliases: simpleRake
### Keywords: design survey category

### ** Examples

data(certify)

# Merge some classes since we have limited population data
# We define classes of COLLEGE as P or not P = N
certify$COLLEGE[   certify$COLLEGE  !=    "P"      ] <- "N"
# We define classes of WORKENV to be I, A, or else = O
certify$WORKENV[ ! certify$WORKENV %in% c("I","A") ] <- "O"

rakeresult <- simpleRake(certify, statpoptotal, "WORKENV", "COLLEGE",
"WOULDYOU", TRUE)

data <- rakeresult$data
pred <- rakeresult$data.est
print(rbind(data,pred))



