predict.rake              package:rake              R Documentation

_P_r_e_d_i_c_t _s_a_m_p_l_e _v_a_l_u_e_s _a_f_t_e_r _R_a_k_e _a_d_j_u_s_t_m_e_n_t _r_e-_w_e_i_g_h_t_i_n_g

_D_e_s_c_r_i_p_t_i_o_n:

     Use 'predict' on a "rake" class object to obtain adjusted sample
     values that reflect the sample weights in 'rake'.

     This is the third function in the 'rake', 'rakeadj',
     'predict.rake' Rake analysis series.

_U_s_a_g_e:

     predict.rake(object,
                col = stop("Prediction column (argument 'col') must be specified."),
                forcefactor = FALSE,
                data = eval(parse(text=dataname(rake)),parent.frame(1)),
                ... )

_A_r_g_u_m_e_n_t_s:

  object: object of class "rake" created with the function 'rake'.

     col: column of 'data' from which re-weighted data will be gathered
          and returned.

forcefactor: logical: should 'data[,col]' be treated as a factor, even
          if it is numeric data?

    data: usually the data.frame from which the rake was generated.

     ...: other arguments to pass to default methods.

_V_a_l_u_e:

     List with entries: 

    data: the original data of interest.

  weight: the adjusted weights from the rake, formatted as a vector
          that corresponds to a column of 'data'.

data.est: the data of interest after re-weighting.

_N_o_t_e:

     Simply use 'predict(rake)' rather than 'predict.rake(rake)'.

_A_u_t_h_o_r(_s):

     Toby Dylan Hocking <tdhock@ocf.berkeley.edu>

_R_e_f_e_r_e_n_c_e_s:

     Sharon L. Lohr. Sampling: Design and Analysis, pp. 269-271.
     Brooks/Cole, Pacific Grove, CA, 1999.

_S_e_e _A_l_s_o:

     'rake' for creating the initial "rake" class object, 'rakeadj' for
     performing the rake adjustment, 'simpleRake' for performing the
     entire Raking process.

_E_x_a_m_p_l_e_s:

     example(rakeadj)
     for( i in 1:5 ) {
       cat("Variable:",names(certify)[i],"\n")
       rakeresult <- predict(r,i,forcefactor=TRUE)
       data <- rakeresult$data
       pred <- rakeresult$data.est
       print(rbind(data,pred))
       cat("\n")
     }

