### Name: readGDAL
### Title: Read/write between GDAL grid maps and Spatial objects
### Aliases: readGDAL writeGDAL
### Keywords: spatial

### ** Examples

x <- readGDAL(system.file("external/test.ag", package="sp")[1])
class(x)
image(x)
summary(x)
x@data[[1]][x@data[[1]] > 10000] <- NA
summary(x)
image(x)

x <- readGDAL(system.file("external/simple.ag", package="sp")[1])
class(x)
image(x)
summary(x)
y = readGDAL(system.file("pictures/Rlogo.jpg", package = "rgdal")[1])
summary(y)
spplot(y, zcol=1:3, names.attr=c("red","green","blue"), 
        col.regions=grey(0:100/100),
        main="example of three-layer (RGB) raster image", as.table=TRUE)
data(meuse.grid)
gridded(meuse.grid) = ~x+y
proj4string(meuse.grid) = CRS("+init=epsg:28992")
fn <- tempfile()
writeGDAL(meuse.grid["dist"], fn)
mg2 <- readGDAL(fn)
proj4string(mg2)
SP27GTIF <- readGDAL(system.file("pictures/SP27GTIF.TIF", package = "rgdal")[1])
summary(SP27GTIF)
image(SP27GTIF, col=grey(1:99/100))
cea <- readGDAL(system.file("pictures/cea.tif", package = "rgdal")[1])
summary(cea)
image(cea, col=grey(1:99/100))
erdas_spnad83 <- readGDAL(system.file("pictures/erdas_spnad83.tif", package = "rgdal")[1])
summary(erdas_spnad83)
image(erdas_spnad83, col=grey(1:99/100))



