### Name: spTransform-methods
### Title: Methods for Function spTransform in package "rgdal"
### Aliases: spTransform-methods spTransform spTransform,ANY-method
###   spTransform,SpatialPoints,CRS-method
###   spTransform,SpatialPointsDataFrame,CRS-method
###   spTransform,SpatialPixelsDataFrame,CRS-method
###   spTransform,SpatialGridDataFrame,CRS-method
###   spTransform,SpatialLines,CRS-method
###   spTransform,SpatialPolygons,CRS-method spTransform.SpatialPoints
###   spTransform.SpatialPointsDataFrame spTransform.SpatialLines
###   spTransform.SpatialLinesDataFrame
###   spTransform,SpatialLinesDataFrame,CRS-method
###   spTransform.SpatialPolygons spTransform.SpatialPolygonsDataFrame
###   spTransform,SpatialPolygonsDataFrame,CRS-method
### Keywords: methods spatial

### ** Examples

data(state)
states <- data.frame(state.x77, state.center)
states <- states[states$x > -121,]
coordinates(states) <- c("x", "y")
proj4string(states) <- CRS("+proj=longlat +ellps=clrk66")
summary(states)
state.ll83 <- spTransform(states, CRS("+proj=longlat +ellps=GRS80"))
summary(state.ll83)
state.merc <- spTransform(states, CRS=CRS("+proj=merc +ellps=GRS80"))
summary(state.merc)
state.merc <- spTransform(states, CRS=CRS("+proj=merc +ellps=GRS80 +units=us-mi"))
summary(state.merc)
## Not run: 
##D states <- data.frame(state.x77, state.center)
##D states <- states[states$x > -121,]
##D coordinates(states) <- c("x", "y")
##D proj4string(states) <- CRS("+init=epsg:4267")
##D summary(states)
##D state.ll83 <- spTransform(states, CRS("+init=epsg:4269"))
##D summary(state.ll83)
##D state.kansasSlcc <- spTransform(states, CRS=CRS("+init=epsg:26978"))
##D summary(state.kansasSlcc)
## End(Not run)
data(meuse)
coordinates(meuse) <- c("x", "y")
proj4string(meuse) <- CRS("+proj=stere +lat_0=52.15616055555555 +lon_0=5.38763888888889 +k=0.999908 +x_0=155000 +y_0=463000 +ellps=bessel +units=m")
summary(meuse)
meuse.utm <- spTransform(meuse, CRS("+proj=utm +zone=32 +ellps=WGS84"))
summary(meuse.utm)
cbind(coordinates(meuse), coordinates(meuse.utm))
kiritimati_primary_roads <- readOGR(system.file("vectors", package = "rgdal")[1], "kiritimati_primary_roads")
kiritimati_primary_roads_ll <- spTransform(kiritimati_primary_roads, CRS("+proj=longlat +ellps=WGS84"))
opar <- par(mfrow=c(1,2))
plot(kiritimati_primary_roads, axes=TRUE)
plot(kiritimati_primary_roads_ll, axes=TRUE, las=1)
par(opar)
scot_BNG <- readOGR(system.file("vectors", package = "rgdal")[1], "scot_BNG")
scot_LL <- spTransform(scot_BNG, CRS("+proj=longlat +datum=WGS84"))
opar <- par(mfrow=c(1,2))
plot(scot_LL, axes=TRUE)
plot(scot_BNG, axes=TRUE, las=1)
toproj <- CRS(proj4string(scot_BNG))
easts <- pretty(bbox(scot_LL)[1,], min.n=4)
easts <- easts[easts > bbox(scot_LL)[1,1] & easts < bbox(scot_LL)[1,2]]
eastlist <- vector(mode="list", length=length(easts))
for (i in 1:length(easts)) eastlist[[i]] <- Line(cbind(rep(easts[i], 100), seq(bbox(scot_LL)[2,1], bbox(scot_LL)[2,2], length.out=100)))
plot(spTransform(SpatialLines(list(Lines(eastlist)), CRS("+proj=longlat +datum=WGS84")), toproj), add=TRUE, col="grey")
norths <- pretty(bbox(scot_LL)[2,], min.n=4)
norths <- norths[norths > bbox(scot_LL)[2,1] & norths < bbox(scot_LL)[2,2]]
northlist <- vector(mode="list", length=length(norths))
for (i in 1:length(norths)) northlist[[i]] <- Line(cbind(seq(bbox(scot_LL)[1,1], bbox(scot_LL)[1,2], length.out=100), rep(norths[i], 100)))
plot(spTransform(SpatialLines(list(Lines(northlist)), CRS("+proj=longlat +datum=WGS84")), toproj), add=TRUE, col="grey")
par(opar)



