### Encoding: latin1

### Name: balancedstratification
### Title: Balanced stratification
### Aliases: balancedstratification
### Keywords: survey

### ** Examples

############
## Example 1
############
# variable of stratification (3 strata)
strat=c(1,1,1,1,1,2,2,2,2,2,3,3,3,3,3)
# matrix of balancing variables
X=cbind(c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15))
# Vector of inclusion probabilities.
# The sample has its size equal to 9.
pik=rep(3/5,times=15)
# Selection of a stratified sample
s=balancedstratification(X,strat,pik,comment=TRUE)
# The sample is
(1:length(pik))[s==1]
############
## Example 2
############
data(MU284)
X=cbind(MU284$P75,MU284$CS82,MU284$SS82,MU284$S82,MU284$ME84)
strat=MU284$REG
pik=inclusionprobabilities(MU284$P75,80)
s=balancedstratification(X,strat,pik,TRUE)
############
## Example 3
############
data(swissmunicipalities)
swiss=swissmunicipalities
X=cbind(swiss$HApoly,
        swiss$Surfacesbois,
        swiss$P00BMTOT,
        swiss$P00BWTOT,
        swiss$POPTOT,
        swiss$Pop020,
        swiss$Pop2040,
        swiss$Pop4065,
        swiss$Pop65P,
        swiss$H00PTOT )
pik=inclusionprobabilities(swiss$POPTOT,400)
sample=balancedstratification(X,swiss$REG,pik,comment=TRUE)
#the sample is
as.character(swiss$Nom[sample==1])



