### Name: Q
### Title: Resonance quality factor of a frequency spectrum
### Aliases: Q
### Keywords: dplot ts

### ** Examples

# bird song
data(tico)
t<-spec(tico,f=22050,wl=512,at=1.1,plot=FALSE,dB=TRUE)
op<-par(mfrow=c(2,1),las=1)
Q(t,range=c(0,11.025),type="l")
Q(t,range=c(0,11.025),type="l",xlim=c(3.8,4.2),ylim=c(-60,0))
title("zoom in")
par(op)
# cricket, changing the dB level
data(pellucens)
p<-spec(pellucens,f=11025,wl=512,at=0.5,plot=FALSE,dB=TRUE)
op<-par(mfrow=c(3,1))
Q(p,range=c(0,11.25/2),type="l",xlim=c(1.8,2.6),ylim=c(-70,0))
title("level = - 3 (default value)",col.main="red")
Q(p,range=c(0,11.25/2),type="l",level=-6,
    xlim=c(1.8,2.6),ylim=c(-70,0),colval="blue")
title("level = - 6",col.main="blue")
Q(p,range=c(0,11.25/2),type="l",level=-9,
    xlim=c(1.8,2.6),ylim=c(-70,0),colval="green")
title("level = - 9",col.main="green")
par(op)



