### Name: autoc
### Title: Short-term autocorrelation of a time wave
### Aliases: autoc
### Keywords: dplot ts

### ** Examples

data(sheep)
# fundamental frequency of a sheep
autoc(sheep,f=8000,wl=512,t=5,fmin=700)
# overlay on spectrogram
spectro(sheep,f=8000,wl=512,ovlp=75,zp=16,scale=FALSE)
par(new=TRUE)
autoc(sheep,f=8000,wl=512,t=5,fmin=700,type="p",col="black",pch=20,
    xaxs="i",yaxs="i",ann=FALSE,yaxt="n")
legend(0.5,3.6,"Fundamental frequency",pch=20,col="black",bty=0,cex=0.7)



