### Name: corspec
### Title: Cross-correlation between two frequency spectra
### Aliases: corspec
### Keywords: dplot ts

### ** Examples

data(tico)
# compare the two first notes spectra
a<-spec(tico,f=22050,wl=512,at=0.2,plot=FALSE)
c<-spec(tico,f=22050,wl=512,at=1.1,plot=FALSE)
op<-par(mfrow=c(2,1), mar=c(4.5,4,3,1))
spec(tico,f=22050,wl=512,at=0.2,col="blue",type="l")
par(new=TRUE)
spec(tico,f=22050,wl=512,at=1.1,col="green",type="l")
legend(x=8,y=0.5,c("Note A", "Note C"),lty=1,col=c("blue","green"),bty="o")
par(mar=c(5,4,2,1))
corspec(a,c,range=c(0,11.025),type="l",
  ylim=c(-0.25,0.8),xaxs="i",yaxs="i",las=1)
par(op)
# different correlation methods give different results...
op<-par(mfrow=c(3,1))
corspec(a,c,range=c(0,11.025),
  type="l",xaxs="i",las=1, ylim=c(-0.25,0.8))
title("spearmann correlation (by default)")
corspec(a,c,range=c(0,11.025),
  type="l",xaxs="i",las=1,ylim=c(0,1),method="pearson")
title("pearson correlation")
corspec(a,c,range=c(0,11.025),
  type="l",xaxs="i",las=1,ylim=c(-0.23,0.5),method="kendall")
title("kendall correlation")
par(op)
# inverting x and y does not give exactly similar results
op<-par(mfrow=c(2,1),mar=c(2,4,3,1))
corspec(a,c,range=c(0,11.025),type="l")
corspec(c,a,range=c(0,11.025),type="l")
par(op)



