### Name: meanspec
### Title: Mean frequency spectrum of a time wave
### Aliases: meanspec
### Keywords: dplot ts

### ** Examples

data(orni)
# compute the mean spectrum of the whole time wave
meanspec(orni,f=22050,wl=512,type="l")
# compute the mean spectrum of a time wave section (from 0.32 s to 0.39 s)
meanspec(orni,f=22050,wl=512,from=0.32,to=0.39,type="l")
# different window lengths
op<-par(mfrow=c(3,1))
meanspec(orni,f=22050,wl=256,type="l")
title("wl=256")
meanspec(orni,f=22050,wl=1024,type="l")
title("wl=1024")
meanspec(orni,f=22050,wl=4096,type="l")
title("wl=4096")
par(op)
# different overlap values (almost no effects here...)
op<-par(mfrow=c(3,1))
meanspec(orni,f=22050,wl=512,type="l")
title("ovlp=0")
meanspec(orni,f=22050,wl=512,ovlp=50,type="l")
title("ovlp=50")
meanspec(orni,f=22050,wl=512,ovlp=95,type="l")
title("ovlp=95")
par(op)
# use of flim to zoom in
op<-par(mfrow=c(2,1))
meanspec(orni,f=22050,wl=512,type="l")
title("zoom in")
meanspec(orni,f=22050,wl=512,type="l",flim=c(4,6))
par(op)
# comparaison of spectrum and mean spectrum
op<-par(mfrow=c(2,1))
spec(orni,f=22050,type="l")
title("spec()")
meanspec(orni,f=22050,wl=512,type="l")
title("meanspec()")
par(op)



