### Name: spec
### Title: Frequency spectrum of a time wave
### Aliases: spec
### Keywords: dplot ts

### ** Examples

data(tico)
# spectrum of the whole signal, in absolute or dB amplitude,
# horizontaly or vertically
op<-par(mfrow=c(2,2))
spec(tico,f=22050,type="l")
spec(tico,f=22050,type="l",col="red",plot=2)
spec(tico,f=22050,type="l",dB=TRUE,col="blue")
spec(tico,f=22050,type="l",dB=TRUE,col="green",plot=2)
par(op)
# spectra computed at specific locations with peak value
op<-par(mfrow=c(2,2))
spec(tico,f=22050,wl=512,at=0.2,type="l",peak=175)
title("Note A")
spec(tico,f=22050,wl=512,at=0.7,type="l",peak=175)
title("Note B")
spec(tico,f=22050,wl=512,at=1.1,type="l",peak=175)
title("Note C")
spec(tico,f=22050,wl=512,at=1.6,type="l",peak=165)
title("Note D")
par(op)
# an indirect way to compare spectra 
a<-spec(tico,f=22050,wl=512,at=0.2,plot=FALSE)
b<-spec(tico,f=22050,wl=512,at=0.7,plot=FALSE)
c<-spec(tico,f=22050,wl=512,at=1.1,plot=FALSE)
d<-spec(tico,f=22050,wl=512,at=1.6,plot=FALSE)
all<-cbind(a,b,c,d)
matplot(x=seq(0,11.025,length.out=nrow(all)),y=all,type="l",yaxt="n",
    xlab="Frequency (kHz)",ylab="Amplitude",xaxs="i")
legend(8,0.8,c("Note A","Note B", "Note C", "Note D"),bty="o",
    lty=c(1:4),col=c(1:4))
# spectrum from a particular position to another one
op<-par(mfrow=c(2,1))
oscillo(tico,f=22050)
abline(v=c(0.5,0.9),col="red",lty=2)
text(c("from 0.5 s","to 0.7 s"),
    x=c(0.5,0.9),y=rep(max(tico/1.1),2),col="red",pos=4)
spec(tico,f=22050,wl=512,from=0.5,to=0.9,type="l",col="red")
title("Spectrum of the note B")
par(op)
# spectrum and spectrogram
data(orni)
orni1<-cutw(orni,f=22050,from=0.32,to=0.39)
layout(matrix(c(1,2),nc=2),widths=c(3,1))
par(mar=c(5,4,3,0.5))
spectro(orni1,f=22050,wl=128,zp=8,ovlp=85,scale=FALSE)
par(mar=c(5,1,3,0.5))
spec(orni1,f=22050,type="l",col="red",plot=2,flab="",yaxt="n")



