### Name: spectro
### Title: 2D-spectrogram of a time wave
### Aliases: spectro
### Keywords: dplot ts

### ** Examples

data(tico)
data(peewit)
data(pellucens)
data(alauda)
# simple plots
spectro(tico,f=22050,wl=512)
spectro(tico,f=22050,wl=512,osc=TRUE)
spectro(tico,f=22050,wl=512,scale=FALSE)
spectro(tico,f=22050,wl=512,osc=TRUE, scale=FALSE)
# manipulating wl
op<-par(mfrow=c(2,2))
spectro(tico,f=22050,wl=256,scale=FALSE)
title("wl = 256")
spectro(tico,f=22050,wl=512,scale=FALSE)
title("wl = 512")
spectro(tico,f=22050,wl=1024,scale=FALSE)
title("wl = 1024")
spectro(tico,f=22050,wl=4096,scale=FALSE)
title("wl = 4096")
par(op)
# manipulating ovlp
op<-par(mfrow=c(2,1))
spectro(alauda,f=22050,wl=512,scale=FALSE)
title("ovlp = 0")
spectro(alauda,f=22050,wl=512,ovlp=95,scale=FALSE)
title("ovlp = 95")
par(op)
# a full plot
pellu2<-cutw(pellucens,f=22050,from=1,to=nrow(pellucens)/22050,plot=FALSE)
spectro(pellu2,f=22050,wl=512,ovlp=85,zp=16,osc=TRUE,
    cont=TRUE,contlevels=seq(-30,0,20),colcont="red",
    lwd=1.5,lty=2,palette=rev.terrain.colors)
# black and white spectrogram 
spectro(pellu2,f=22050,wl=512,ovlp=85,zp=16,
    palette=rev.gray.colors)
# colour modifications
spectro(pellu2,f=22050,wl=512,ovlp=85,zp=16,
palette=rev.cm.colors,osc=TRUE,colwave="orchid1") 
op<-par(bg="black",col="white")
spectro(pellu2,f=22050,wl=512,ovlp=85,zp=16,osc=TRUE,palette=rev.heat.colors,
colgrid="white", colwave="white",colaxis="white",collab="white",
colline="white")
par(op)



