### Name: synth
### Title: Synthesis of time wave
### Aliases: synth
### Keywords: dplot ts

### ** Examples

# pure tone
synth(f=22050,d=1,cf=4000)
# pure tones with am
synth(f=22050,d=1,cf=4000,am=c(50,10),osc=TRUE)
# pure tone with +2000 Hz linear fm 
synth(f=22050,d=1,cf=4000,fm=c(0,0,2000))
# pure tone with sinusoidal fm
# (maximum excursion of 1000 Hz, frequency of 10 Hz)
synth(f=22050,d=1,cf=4000,fm=c(1000,10,0),wl=256,ovlp=75)
# pure tone with sinusoidal am
# (maximum excursion of 1000 Hz, frequency of 10 Hz)
# and linear fm (maximum excurion of 1000 Hz
synth(f=22050,d=1,cf=4000,fm=c(1000,10,1000),wl=256,ovlp=75)
# the same with am
synth(f=22050,d=1,cf=4000,am=c(50,10),
    fm=c(1000,10,1000),wl=256,ovlp=75,osc=TRUE)
# more complex sound
F1<-synth(f=22050,cf=2000,d=1,fm=c(500,5,0),plot=FALSE)
F2<-synth(f=22050,a=0.8,cf=4000,d=1,fm=c(500,5,0),plot=FALSE)
F3<-synth(f=22050,a=0.6,cf=6000,d=1,fm=c(500,5,0),plot=FALSE)
F4<-synth(f=22050,a=0.4,cf=8000,d=1,fm=c(500,5,0),plot=FALSE)
final1<-F1+F2+F3+F4
spectro(final1,f=22050,wl=512,ovlp=75,scale=FALSE)
# insert 0.25 s silence
final1.1<-as.matrix(final1[1:(nrow(final1)/2),])
final1.2<-as.matrix(rep(0,0.25*22050))
final1.3<-as.matrix(final1[(nrow(final1)/2):nrow(final1),])
final2<-rbind(final1.1,final1.2,final1.3)
spectro(final2,f=22050,wl=512,ovlp=75,scale=FALSE)



