### Name: segmented
### Title: Segmented relationships in regression models
### Aliases: segmented segmented.default segmented.lm segmented.glm
###   print.segmented summary.segmented print.summary.segmented
### Keywords: regression

### ** Examples

## A linear model with a segmented relationship in each level of 
## a categorical variable
##
## Simulate data
x<-1:100
g<-rep(0:1,c(100,100))
set.seed(15)
y1<- 2+1.5*pmax(x-60,0)+rnorm(100,0,5)
y2<- 2+0.6*pmax(x-60,0)+rnorm(100,0,5)
dati<-data.frame(xx=rep(x,2),yy=c(y1,y2),g=factor(g))
rm(x,g,y1,y2)
## Have a look at the plot
## Not run: plot(dati$xx,dati$yy) 
## Not run: points(dati$xx[dati$g==0],dati$yy[dati$g==0],col=2)
## Fit the linear model
obj<-lm(yy~0+g+xx:g,data=dati) 
## Fit segmented models
## Model I: ignore the stratification, assume an equal difference-in-slopes 
## parameter between groups
ogg0<-segmented(obj,Z=xx,psi=60)
## Model II: now stratificate by g. Here note that psi[i] refers to the 
## segmented relationship in the ith level of W
ogg1<-segmented(obj,Z=xx,W=g,psi=c(50,70),visual=TRUE)
## Results....
ogg0
summary(ogg1)
## Have a look at the fitted models
## model I
## Not run: points(dati$xx[dati$g==0],ogg0$fitted[dati$g==0],pch=3,col=2)
## Not run: points(dati$xx[dati$g==1],ogg0$fitted[dati$g==1],pch=3,col=1)
## model II
## Not run: points(dati$xx[dati$g==0],ogg1$fitted[dati$g==0],pch=20,col=2)
## Not run: points(dati$xx[dati$g==1],ogg1$fitted[dati$g==1],pch=20,col=1)
## Not run: legend(5,60,legend=c("model I","model II"),pch=c(3,20))



