### Name: uco
### Title: Codon usage indices
### Aliases: uco
### Keywords: manip

### ** Examples

## Show all possible codons:
words()
## Make a coding sequence from this:
(cds <- s2c(paste(words(), collapse = "")))
## Get codon counts:
uco(cds, index = "eff")
## Get codon relative frequencies:
uco(cds, index = "freq")
## Get RSCU values:
uco(cds, index = "rscu")
## Show what's happen with ambiguous bases:
uco(s2c("aaannnttt"))
## Use a real coding sequence:
rcds <- read.fasta(File = system.file("sequences/malM.fasta", package = "seqinr"))[[1]]
uco( rcds, index = "freq")
uco( rcds, index = "eff")
uco( rcds, index = "rscu")
uco( rcds, as.data.frame = TRUE)



