### Name: pl.ds
### Title: Plot Data and Smoother / Fitted Values
### Aliases: pl.ds
### Keywords: hplot

### ** Examples

 data(cars)
 x <-  cars$speed
 yd <- cars$dist
 ys <- lowess(x, yd,f = .2)$y
 pl.ds(x, yd, ys)

 ## More interesting : Version of example(Theoph)
 data(Theoph)
 Th4 <- subset(Theoph, Subject == 4)
 fm1 <- nls(conc ~ SSfol(Dose, Time, lKe, lKa, lCl), data = Th4)
 pl.ds(Th4$Time, Th4$conc, fitted(fm1),
       sub  = "Theophylline data - Subject 4 only",
       segP = list(lty=1,col=2), las = 1)
 xvals <- seq(0, par("usr")[2], len = 55)
 lines(xvals, predict(fm1, newdata = list(Time = xvals)), col = 4)



