### Name: rnls
### Title: Robust Nonlinear Regression
### Aliases: rnls print.rnls fitted.rnls predict.rnls residuals.rnls
###   summary.rnls
### Keywords: robust regression

### ** Examples

DNase1 <- DNase[ DNase$Run == 1, ]

## note that selfstarting models doesn't work yes 

##--- without conditional linearity ---

## classical
fm3DNase1 <- nls( density ~ Asym/(1 + exp(( xmid - log(conc) )/scal ) ),
                  data = DNase1,
                  start = list( Asym = 3, xmid = 0, scal = 1 ),
                  trace = TRUE )
summary( fm3DNase1 )

## robust
frm3DNase1 <- rnls(density ~ Asym/(1 + exp(( xmid - log(conc) )/scal ) ),
                  data = DNase1, trace = TRUE,
                  start = list( Asym = 3, xmid = 0, scal = 1 ))
## FAILS (summary.nls): summary( frm3DNase1 )

##--- using conditional linearity ---

## classical
fm2DNase1 <- nls( density ~ 1/(1 + exp(( xmid - log(conc) )/scal ) ),
                  data = DNase1,
                  start = c( xmid = 0, scal = 1 ),
                  alg = "plinear", trace = TRUE )
summary( fm2DNase1 )

## robust
if(FALSE) { # currently fails 
frm2DNase1 <- rnls(density ~ 1/(1 + exp(( xmid - log(conc) )/scal ) ),
                  data = DNase1, start = c( xmid = 0, scal = 1 ),
                  alg = "plinear", trace = TRUE )
summary( frm2DNase1 )
} # not yet

### -- new examples
DNase1[10,"density"] <- 2*DNase1[10,"density"]

fm3DNase1 <- nls(density ~  Asym/(1 + exp(( xmid - log(conc) )/scal ) ),
                       data = DNase1, trace = TRUE,
                       start = list( Asym = 3, xmid = 0, scal = 1 ))

## robust
frm3DNase1 <- rnls(density ~  Asym/(1 + exp(( xmid - log(conc) )/scal ) ),
                   data = DNase1, trace = TRUE,
                   start = list( Asym = 3, xmid = 0, scal = 1 ))
frm3DNase1
coef(frm3DNase1)

## predict() {and plot}:
h.x <- lseq(min(DNase1$conc), max(DNase1$conc), length = 100)
nDat <- data.frame(conc = h.x)

h.p  <- predict(fm3DNase1, newdata = nDat)# classical
h.rp <- predict(frm3DNase1, newdata= nDat)# robust

plot(density ~ conc, data=DNase1, log="x",
     main = deparse(frm3DNase1$call$formula))
lines(h.x, h.p,  col="blue")
lines(h.x, h.rp, col="magenta")
legend("topleft", c("classical nls()", "robust    rnls()"),
       lwd = 1, col= c("blue", "magenta"))



