TA.plot               package:sfsmisc               R Documentation

_T_u_k_e_y-_A_n_s_c_o_m_b_e _P_l_o_t (_r_e_s_i_d_u_a_l _v_s. _f_i_t_t_e_d) _o_f _a _L_i_n_e_a_r _M_o_d_e_l.

_D_e_s_c_r_i_p_t_i_o_n:

     From a linear (or glm) model fitted, produce the so-called
     Tukey-Anscombe plot.  Useful (optional) additions include:  
     0-line, lowess smooth, 2sigma lines,  and automatic labeling of
     observations.

_U_s_a_g_e:

     TA.plot(lm.res,
             fit= fitted(lm.res), res= residuals(lm.res, type="pearson"),
             labels= NULL, main= mk.main(), xlab = "Fitted values",
             draw.smooth= n >= 10, show.call = TRUE, show.2sigma= TRUE,
             lo.iter = NULL, lo.cex= NULL,
             par0line  = list(lty = 2, col = 2),
             parSmooth = list(lwd = 1.5, lty = 4, col = 3),
             parSigma  = list(lwd = 1.2, lty = 3, col = 4),
             ...)

_A_r_g_u_m_e_n_t_s:

  lm.res: Result of 'lm(..)', 'aov(..)', 'glm(..)' or a similar object.

     fit: fitted values; you probably want the default here.

     res: residuals to use. Default: *Weighted* ("Pearson") residuals
          if weights have been used for the model fit.

  labels: strings to use as plotting symbols for each point.
          Default(NULL): extract observations' names or use its
          sequence number. Use, e.g., "*" to get simple '*' symbols. 

    main: main title to plot. Default: sophisticated, resulting in
          something like "Tukey-Anscombe Plot of :   y \~ x" 
          constructed from 'call(.)' in 'lm.res'. 

    xlab: x-axis lable for plot.

draw.smooth: logical; if 'TRUE', draw a 'lowess' smoother (with
          automatic smoothing fraction).

show.call: logical; if 'TRUE', write the "call"ing syntax with which
          the fit was done.

show.2sigma: logical; if 'TRUE', draw horizontal lines at +- 2 sigma
          where sigma is 'mad(resid)'.

 lo.iter: positive integer, giving the number of lowess robustness
          iterations. The default depends on the model and is '0' for
          non Gaussian 'glm''s.

  lo.cex: character expansion ("cex") for lowess and other marginal
          texts.

par0line: a list of arguments (with reasonable defaults) to be passed
          to 'abline(.)' when drawing the x-axis, i.e., the y = 0 line.

parSmooth, parSigma: each a list of arguments (with reasonable default)
          for drawing the smooth curve (if 'draw.smooth' is true), or
          the horizontal sigma boundaries (if 'show.2sigma' is true)
          respectively.

     ...: further graphical parameters are passed to 'n.plot(.)'.

_S_i_d_e _E_f_f_e_c_t_s:

     The above mentioned plot is produced on the current graphic
     device.

_A_u_t_h_o_r(_s):

     Martin Maechler, Seminar fuer Statistik, ETH Zurich, Switzerland;
     maechler@stat.math.ethz.ch

_S_e_e _A_l_s_o:

     'plot.lm' which also does a QQ normal plot and more.

_E_x_a_m_p_l_e_s:

     data(stackloss)
     TA.plot(lm(stack.loss ~ stack.x))

     example(airquality)
     summary(lmO <- lm(Ozone ~ ., data= airquality))
     TA.plot(lmO)
     TA.plot(lmO, label = "O") # instead of case numbers

     if(FALSE) { 
      TA.plot(lm(cost ~ age+type+car.age, claims, weights=number, na.action=na.omit))
     }

     ##--- for  aov(.) : -------------
     data(Gun, package = "nlme")
     TA.plot( aov(rounds ~ Method + Physique/Team, data = Gun))

     ##--- Not so clear what it means for GLM, but: ------
     if(require(rpart)) { # for the two datasets only
      data(solder, package = "rpart")
      TA.plot(glm(skips ~ ., data = solder, family = poisson), cex= .6)

      data(kyphosis, package = "rpart")
      TA.plot(glm(Kyphosis ~ poly(Age,2) + Start, data=kyphosis, family = binomial),
              cex=.75) # smaller title and plotting characters
     }

