p.ts                 package:sfsmisc                 R Documentation

_p_l_o_t._t_s _w_i_t_h _m_u_l_t_i-_p_l_o_t_s _a_n_d _A_u_t_o-_T_i_t_l_e - _o_n _1 _p_a_g_e

_D_e_s_c_r_i_p_t_i_o_n:

     For longer time-series, it is sometimes important to spread the
     time-series plots over several subplots. p.ts(.) does this both
     automatically, and under manual control.

     Actually, this is a generalization of 'plot.ts' (with different
     defaults).

_U_s_a_g_e:

     p.ts(x, nrplots = max(1, min(8, n %/% 400)), overlap = nk %/% 16,
          date.x = NULL, do.x.axis = !is.null(date.x), do.x.rug = FALSE,
          ax.format, main.tit = NULL, ylim = NULL, ylab = "", xlab = "Time",
          quiet = FALSE, mgp = c(1.25, .5, 0), ...)

_A_r_g_u_m_e_n_t_s:

       x: timeseries (possibly multivariate) or numeric vector.

 nrplots: number of sub-plots.  Default: in {1..8}, approximately
          'n/400' if possible.

 overlap: by how much should subsequent plots overlap. Defaults to
          about 1/16 of sub-length on each side.

  date.x: a time "vector" of the same length as 'x' and coercable to
          class '"POSIXct"' (see DateTimeClasses).

do.x.axis: logical specifying if an x axis should be drawn (i.e., tick
          marks and labels).

do.x.rug: logical specifying if 'rug' of 'date.x' values should drawn
          along the x axis.

ax.format: when 'do.x.axis' is true, specify the 'format' to be used in
          the call to 'axis.POSIXct'.

main.tit: *Main* title (over all plots).  Defaults to name of 'x'.

    ylim: numeric(2) or NULL; if the former, specifying the y-range for
          the plots. Defaults to a common pretty range.

ylab, xlab: labels for y- and x-axis respectively, see description in
          'plot.default'.

   quiet: logical; if 'TRUE', there's no reporting on each subplot.

     mgp: numeric(3) to be passed to 'mult.fig()', see 'par(mgp = .)'.

     ...: further graphic parameters for each 'plot.ts(..)'.

_S_i_d_e _E_f_f_e_c_t_s:

     A page of 'nrplots' subplots is drawn on the current graphics
     device.

_A_u_t_h_o_r(_s):

     Martin Maechler, maechler@stat.math.ethz.ch; July 1994 (for S).

_S_e_e _A_l_s_o:

     'p.ts()' calls 'mult.fig()' for setup. Further, 'plot.ts' and
     'plot'.

_E_x_a_m_p_l_e_s:

     stopifnot(require(stats))
     ## stopifnot(require(datasets))

     data(sunspots)
     p.ts(sunspots, nr=1) # == usual  plot.ts(..)
     p.ts(sunspots)
     p.ts(sunspots, nr=3, col=2)

     data(EuStockMarkets)
     p.ts(EuStockMarkets[,"SMI"])
     ## multivariate :
     p.ts(log10(EuStockMarkets), col = 2:5)

     ## with Date - x-axis (dense random dates):
     set.seed(12)
     x <- as.Date("2000-02-29") + cumsum(1+ rpois(1000, lambda= 2.5))
     z <- cumsum(.1 + 2*rt(1000, df=3))
     p.ts(z, 4, date.x = x)
     p.ts(z, 6, date.x = x, ax.format = "%b %Y", do.x.rug = TRUE)

