### Name: plot.SIMEX
### Title: Plot method for the SIMEX- and MCSIMEX-class
### Aliases: plot.SIMEX plot.MCSIMEX
### Keywords: models

### ** Examples

a <- rnorm(100)
b <- a*20 + rnorm(100,100,10)
e <- a + rnorm(100,1,5)
naive.model <- lm(a~ b + e, x= TRUE,y =TRUE)

w<- simex(model = naive.model
        , SIMEXvariable = c("b","e")
        , measurement.error = c(10,5)
        , lambda=c(0.5,1,1.5,1.75,2.25,2.5,3))

plot(w, ask = FALSE, mfrow = c(2,2))



