### Name: elev.com
### Title: Test for equal elevation among several lines fitted with
###   (standardised) major axes of common slope
### Aliases: elev.com
### Keywords: htest

### ** Examples

#load leaf longevity data
data(leaflife)

#Test for common SMA slope amongst species at low rainfall sites
#with different levels of soil nutrients
leaf.low.rain=leaflife[leaflife$rain=='low',]
slope.com(log10(longev), log10(lma), soilp, data=leaf.low.rain)

#Now test for common elevation of the groups fitted with an axis
#of common slope, at low rainfall sites:
elev.com(log10(longev), log10(lma), soilp, data = leaf.low.rain)

#Or test for common elevation amongst the MA's of common slope,
#for low rainfall sites, and construct 99
#for the common elevation:
elev.com(log10(longev), log10(lma), soilp, method='MA',
    data = leaf.low.rain, alpha=0.01)  



