### Name: smatr
### Title: (Standardised) Major Axis Estimation and Testing Routines
### Aliases: smatr-package smatr
### Keywords: documentation

### ** Examples

    #load the leaflife dataset:
    data(leaflife)

    #consider only the low rainfall sites:
    leaf.low.rain=leaflife[leaflife$rain=='low',]

    #construct a plot
    plot(log10(leaf.low.rain$lma), log10(leaf.low.rain$longev), xlab='leaf mass per area [log scale]', ylab='leaf longevity [log scale]')

    #test if the SMA slope amongst species at low rainfall sites is 1, for log (base 10) transformed data:
    slope.test(log10(longev), log10(lma), data=leaf.low.rain)
    
    #test if the MA slope is 2/3
    slope.test(log10(longev), log10(lma), data=leaf.low.rain, test.value = 2/3, method = 'MA')

    #produce CI's for MA slope and elevation:
    line.cis(log10(longev),log10(lma),data=leaf.low.rain, method=2)

    #now construct a scatterplot, with different colours for different sites
    plot(leaflife$lma,leaflife$longev,type="n",xlab="leaf mass per area [log scale]",ylab="leaf longevity [log scale]",log="xy")
    colours <- c("blue", "red", "green", "yellow")
    points(leaflife$lma,leaflife$longev,col=colours[as.numeric(leaflife$site)])
    legend(55,5,as.character(unique(leaflife$site)),col=colours,pch=rep(1,4))

    #test for a common SMA slope amongst species from sites with different rainfall/nutrients:
    fit.slopes <- slope.com(log10(longev), log10(lma), site, data = leaflife)

    #Test for common SMA slope amongst species at low rainfall sites with different levels of soil nutrients
    slope.com(log10(longev), log10(lma), soilp, data=leaf.low.rain)
    
    #Now test for common elevation of the groups fitted with an axis of common slope, at low rainfall sites:
    elev.com(log10(longev), log10(lma), soilp, data = leaf.low.rain)

    #Now test for no shift along the axes of common slope, for sites with different soil nutrient levels but low rainfall:
    shift.com(log10(longev), log10(lma), soilp, data=leaf.low.rain)

    #Test for common major axis slope, and construct 90
    slope.com(log10(longev), log10(lma), site, data=leaflife, method="MA", alpha=0.1)

    #Test for common elevation amongst the MA's of common slope, for low rainfall sites, and construct 99
    elev.com(log10(longev), log10(lma), soilp, method="MA", data = leaf.low.rain, alpha=0.01)



