elev.com                package:smatr                R Documentation

_T_e_s_t _f_o_r _e_q_u_a_l _e_l_e_v_a_t_i_o_n _a_m_o_n_g _s_e_v_e_r_a_l _l_i_n_e_s _f_i_t_t_e_d _w_i_t_h (_s_t_a_n_d_a_r_d_i_s_e_d) _m_a_j_o_r _a_x_e_s _o_f _c_o_m_m_o_n _s_l_o_p_e

_D_e_s_c_r_i_p_t_i_o_n:

     Test if several major axis or standardised major axis lines share
     a common elevation.

_U_s_a_g_e:

     elev.com(y, x, groups, data = NULL, method = 'SMA', alpha = 0.05,
       V = array(0, c(2, 2, length(unique(groups)))), group.names = sort(unique(groups)))

_A_r_g_u_m_e_n_t_s:

       y: The Y-variable for all observations (as a vector) 

       x: The X-variable for all observations (as a vector) 

  groups: Coding variable identifying which group each observation
          belongs to (as a factor or vector) 

    data: (optional) data frame containing the data 

  method: The line fitting method: 

          '_S_M_A' _o_r _1 standardised major axis (this is the default) 

          '_M_A' _o_r _2 major axis 

   alpha: The desired confidence level for the 100(1-alpha)% confidence
          interval for the common elevation. (Default value is 0.05,
          which returns a 95% confidence interval.) 

       V: The estimated variance matrices of measurement error, for
          each group. This is a 3-dimensional array with measurement
          error in Y in the first row and column, error in X in the
          second row and column,and groups running along the third
          dimension. Default is that there is no measurement error. 

group.names: (optional: rarely required). A vector containing the
          labels for `groups'. (Only actually useful for reducing
          computation time in simulation work). 

_D_e_t_a_i_l_s:

     Calculates a Wald statistic to test for equal elevation of several
     MA's or SMA's with a common slope. This is done by testing for
     equal mean residual scores across groups.

     Note that this test is only valid if it is reasonable to assume
     that the axes for the different groups all have the same slope.

     The test assumes the following:

        *  each group of observations was independently sampled

        *  the axes fitted to all groups have a common slope

        *  y and x are linearly related within each group

        *  residual scores independently follow a normal distribution
           with equal variance at all points along the line, within
           each group

     Note that we do not need to assume equal variance across groups,
     unlike in tests comparing several linear regression lines.

     The assumptions can be visually checked by plotting residual
     scores against fitted axis scores, and by constructing a Q-Q plot
     of residuals against a normal distribution.  Residual scores can
     be obtained as y-bx, and for fitted axis scores y+bx (for SMA) or
     by+lx (for MA or `lamest'), where b represents the common slope
     estimate, and l the error variance ratio. If there is a distinct
     increasing or decreasing trend within any of the groups, this
     suggests that all groups do not share a common slope.

     A plot of residual scores against fitted axis scores can also be
     used as a visual test for common elevation. If residual scores
     generally differ across groups (with some groups generally having
     larger residual scores than others) then this is evidence that the
     groups do not share a common elevation.

     The common slope (b) is estimated from a maximum of 100
     iterations, convergence is reached when the change in b < 10^-6.

_V_a_l_u_e:

   stat : The Wald statistic testing for no shift along the common axis

      p : The P-value of the test. This is calculated assuming that
          stat has a chi-square distribution with (g-1) df, if there
          are g groups

      a : The estimated common elevation

     ci : A 100(1-alpha)% confidence interval for the true common
          elevation

     as : Separate elevation estimates for each group

_A_u_t_h_o_r(_s):

     Warton, D. David.Warton@unsw.edu.au, translated to R by Ormerod,
     J. 2005-12-08

_R_e_f_e_r_e_n_c_e_s:

     Warton D. I., Wright I. J., Falster D. S. and Westoby M. (2006) A
     review of bivariate line-fitting methods for allometry. 
     _Biological Reviews_ (in press)

_S_e_e _A_l_s_o:

     'line.cis', 'slope.com', 'shift.com'

_E_x_a_m_p_l_e_s:

     #load leaf longevity data
     data(leaflife)

     #Test for common SMA slope amongst species at low rainfall sites
     #with different levels of soil nutrients
     leaf.low.rain=leaflife[leaflife$rain=='low',]
     slope.com(log10(longev), log10(lma), soilp, data=leaf.low.rain)

     #Now test for common elevation of the groups fitted with an axis
     #of common slope, at low rainfall sites:
     elev.com(log10(longev), log10(lma), soilp, data = leaf.low.rain)

     #Or test for common elevation amongst the MA's of common slope,
     #for low rainfall sites, and construct 99
     #for the common elevation:
     elev.com(log10(longev), log10(lma), soilp, method='MA',
         data = leaf.low.rain, alpha=0.01)  

