slope.com               package:smatr               R Documentation

_C_o_m_m_o_n _s_l_o_p_e _t_e_s_t _a_m_o_n_g_s_t _s_e_v_e_r_a_l _a_l_l_o_m_e_t_r_i_c _l_i_n_e_s

_D_e_s_c_r_i_p_t_i_o_n:

     Test if several major axis or standardised major axis lines share
     a common slope

_U_s_a_g_e:

     slope.com(y, x, groups, method = 'SMA', alpha = 0.05, data = NULL, intercept = TRUE,
        V = array(0, c(2, 2, length(unique(groups)))), group.names = sort(unique(groups)),
        ci = TRUE, bs = TRUE)

_A_r_g_u_m_e_n_t_s:

       y: The Y-variable for all observations (as a vector) 

       x: The X-variable for all observations (as a vector) 

  groups: Coding variable identifying which group each observation
          belongs to (as a factor or vector) 

  method: The line fitting method:

          '_S_M_A' _o_r _1 standardised major axis (this is the default)

          '_M_A' _o_r _2 major axis

          '_l_a_m_e_s_t' _o_r _3 Error variance ratio is estimated from the data

   alpha: The desired confidence level for the 100(1-alpha)% confidence
          interval for the common slope. (Default value is 0.05, which
          returns a 95% confidence interval.) 

    data: (optional) data frame containing the data 

intercept: (logical) Whether or not the line includes an  intercept.

          _F_A_L_S_E no intercept, so the line is forced through the origin 

          _T_R_U_E an intercept is fitted (this is the default) 

       V: The estimated variance matrices of measurement error, for
          each group. This is a 3-dimensional array with measurement
          error in Y in the first row and column, error in X in the
          second row and column, and groups running along the third
          dimension. Default is that there is no measurement error. 

group.names: (optional: rarely required). A vector containing the
          labels for `groups'. (Only actually useful for reducing
          computation time in simulation work). 

      ci: (logical) Whether or not to return a confidence interval for
          the common slope. 

      bs: (logical) Whether or not to return the slopes for the
          separate groups, with confidence intervals. 

_D_e_t_a_i_l_s:

     For several bivariate groups of observations, this function tests
     if the line-of-best-fit has a common slope for all samples, when
     the line-of-best-fit is estimated using the major axis,
     standardised major axis, or a more general version of these
     methods in which the error variance ratio is estimated from the
     data.

     The test assumes the following:

        1.  each group of observations was independently sampled

        2.  y and x are linearly related within each group

        3.  residuals independently follow a normal distribution with
           equal variance at all points along the line, within each
           group

     Note that we do not need to assume equal variance across groups,
     unlike in the standard test for common slope for linear
     regression.

     The assumptions can be visually checked by plotting residuals
     against fitted axis scores, and by constructing a Q-Q plot* of
     residuals against a normal distribution.  An appropriate residual
     variable is y-b_i*x, and for fitted axis scores y+b_i*x (for SMA)
     or b_i*y+lx (for MA or `lamest'), where b_i represents the
     estimated slope for group i, and l the error variance ratio.

     If a plot of residuals against fitted axis scores is produced in
     which the estimated common slope (b) is used rather than the
     slopes estimated within each group (b_i), this can be used as a
     visual test for common slope. If there is a distinct increasing or
     decreasing trend within any of the groups, this suggests that all
     groups do not share a common slope.

     The common slope is estimated from a maximum of 100 iterations,
     convergence is reached when the change in b is < 10^-6.

_V_a_l_u_e:

     lr : The (Bartlett-corrected) likelihood ratio statistic testing
          for common slope

      p : The P-value of the test. This is calculated assuming that lr
          has a chi-square distribution with (g-1) df, if there are g
          groups

      b : The common slope estimate

   varb : The sample variance of the common slope

     ci : A 100(1-alpha)% confidence interval for the common slope

 lambda : The error variance ratio - the ratio of error variance in y
          to error variance in x. For MA, this is assumed to be 1. for
          SMA, this is assumed to be b^2. For the `lamest' method, the
          error variance ratio is estimated from the data under the
          common slope assumption.

     bs : The slopes and confidence intervals for data from each group.

_A_u_t_h_o_r(_s):

     Warton, D. David.Warton@unsw.edu.au, translated to R by Ormerod,
     J. 2005-12-08

_R_e_f_e_r_e_n_c_e_s:

     Warton D. I. and Weber N. C. (2002) Common slope tests for
     bivariate structural relationships.  _Biometrical Journal_ *44*,
     161-174.

     Warton D. I., Wright I. J., Falster D. S. and Westoby M. (2006) A
     review of bivariate line-fitting methods for allometry. 
     _Biological Reviews_ (in press)

_S_e_e _A_l_s_o:

     'line.cis', 'elev.com', 'shift.com'

_E_x_a_m_p_l_e_s:

     #load leaf longevity data
     data(leaflife)

     #plot the data, with different symbols for different groups.
     plot(leaflife$lma, leaflife$longev, type='n', log='xy', xlab=
        'leaf mass per area [log scale]', ylab='leaf longevity [log scale]')
     colours <- c('blue', 'red', 'green', 'yellow')
     points(leaflife$lma, leaflife$longev,
        col=colours[as.numeric(leaflife$site)])
     legend(55, 5, as.character(unique(leaflife$site)), col=colours,
        pch=rep(1,4))

     #test for common SMA slope of log(leaf longevity) vs log(LMA),
     #across species sampled at different sites:
     fit <- slope.com(log10(longev), log10(lma), site, data = leaflife)
     fit

     #Residual vs fits plots for SMA fit of each site
     y = log10(leaflife$longev)
     x = log10(leaflife$lma)
     site=leaflife$site
     par( mfrow=c(2,2) )
     plot(y[site==1] + fit$bs[1,1] * x[site==1], y[site==1] - fit$bs[1,1] 
        * x[site==1], xlab='fits (site 1)', ylab='residuals (site 1)')
     plot(y[site==2] + fit$bs[1,2] * x[site==2], y[site==2] - fit$bs[1,2]
        * x[site==2], xlab='fits (site 2)', ylab='residuals (site 2)')
     plot(y[site==3] + fit$bs[1,3] * x[site==3], y[site==3] - fit$bs[1,3]
        * x[site==3], xlab='fits (site 3)', ylab='residuals (site 3)')
     plot(y[site==4] + fit$bs[1,4] * x[site==4], y[site==4] - fit$bs[1,4]
        * x[site==4], xlab='fits (site 4)', ylab='residuals (site 4)')

     #Test for common SMA slope amongst species at low rainfall sites
     #with different levels of soil nutrients
     leaf.low.rain=leaflife[leaflife$rain=='low',]
     slope.com(log10(longev), log10(lma), soilp, data=leaf.low.rain)

     #test for common MA slope:
     slope.com(log10(longev), log10(lma), site, data = leaflife,
        method='MA')

     #test for common MA slope, and produce a 90
     slope.com(log10(longev), log10(lma), site, data = leaflife,
        method='MA', alpha=0.1)

