### Name: netlogit
### Title: Logistic Regression for Network Data
### Aliases: netlogit
### Keywords: regression math graphs

### ** Examples

#Create some input graphs
x<-rgraph(20,4)

#Create a response structure
y.l<-x[1,,]+4*x[2,,]+2*x[3,,]   #Note that the fourth graph is 
                                #unrelated
y.p<-apply(y.l,c(1,2),function(a){1/(1+exp(-a))})
y<-rgraph(20,tprob=y.p)

#Fit a netlogit model
nl<-netlogit(y,x,reps=100)

#Examine the results
summary(nl)



