sp.mantel.mc              package:spdep              R Documentation

_M_a_n_t_e_l-_H_u_b_e_r_t _s_p_a_t_i_a_l _g_e_n_e_r_a_l _c_r_o_s_s _p_r_o_d_u_c_t _s_t_a_t_i_s_t_i_c

_D_e_s_c_r_i_p_t_i_o_n:

     A permutation test for the spatial general cross product statistic
     with Moran (C(i,j) = z(i)*z(j)), Geary  (C(i,j) = (z(i) -
     z(j))^2), and Sokal  (C(i,j) = |z(i) - z(j)|) criteria, for z(i) =
     (x(i) - mean(x))/sd(x). 'plot.mc.sim' is a helper function to plot
     the outcomes of the permutation test.

_U_s_a_g_e:

     sp.mantel.mc(var, listw, nsim, type = "moran", zero.policy = FALSE,
      alternative = "greater", spChk=NULL)
     plot.mc.sim(x, ...)

_A_r_g_u_m_e_n_t_s:

     var: a numeric vector the same length as the neighbours list in
          listw

   listw: a 'listw' object created for example by 'nb2listw'

    nsim: number of permutations

    type: "moran", "geary" or "sokal" criteria for similarity

zero.policy: if TRUE assign zero to the lagged value of zones without 
          neighbours, if FALSE assign NA

alternative: a character string specifying the alternative hypothesis, 
          must be one of "greater" (default), or "less".

   spChk: should the data vector names be checked against the spatial
          objects for identity integrity, TRUE, or FALSE, default NULL
          to use 'get.spChkOption()'

       x: the object to be plotted

     ...: further arguments passed through

_V_a_l_u_e:

     A list with class 'htest' and 'mc.sim' containing the following
     components: 

statistic: the value of the observed Geary's C.

parameter: the rank of the observed Geary's C.

alternative: a character string describing the alternative hypothesis.

  method: a character string giving the method used.

data.name: a character string giving the name(s) of the data, and the 
          number of simulations.

 p.value: the pseudo p-value of the test.

     res: nsim simulated values of statistic, final value is observed 
          statistic

estimate: the mean and variance of the simulated distribution.

_A_u_t_h_o_r(_s):

     Roger Bivand Roger.Bivand@nhh.no

_R_e_f_e_r_e_n_c_e_s:

     Cliff, A. D., Ord, J. K. 1981 Spatial processes, Pion, p. 22-24,
     Haining, R. 1990 _Spatial data analysis in the social and
     environmental sciences_, Cambridge: Cambridge University Press, p.
     230-1. The function has been checked against general matrix code
     posted to the  r-help list by Ben Bolker on 1 May 2001; another
     'mantel()' function is in the vegan package.

_S_e_e _A_l_s_o:

     'moran.mc', 'joincount.mc',  'geary.mc'

_E_x_a_m_p_l_e_s:

     data(oldcol)
     sim1 <- sp.mantel.mc(spNamedVec("CRIME", COL.OLD), nb2listw(COL.nb),
      nsim=99, type="geary", alternative="less")
     sim1
     plot(sim1)
     sp.mantel.mc(spNamedVec("CRIME", COL.OLD), nb2listw(COL.nb), nsim=99,
      type="sokal", alternative="less")
     sp.mantel.mc(spNamedVec("CRIME", COL.OLD), nb2listw(COL.nb), nsim=99,
      type="moran")

