### Encoding: latin1

### Name: eire
### Title: Eire data sets
### Aliases: eire eire.df eire.polys.utm eire.coords.utm eire.nb
### Keywords: datasets

### ** Examples

data(eire)
summary(eire.df$A)
brks <- round(fivenum(eire.df$A), digits=2)
cols <- rev(heat.colors(4))
library(maptools)
plot(eire.polys.utm,
 col=cols[findInterval(eire.df$A, brks)], forcefill=FALSE)
title(main="Percentage with blood group A in Eire")
legend(x=c(-50, 70), y=c(6120, 6050), leglabs(brks), fill=cols, bty="n")
plot(eire.polys.utm, forcefill=FALSE)
plot(eire.nb, eire.coords.utm, add=TRUE)
lA <- lag.listw(nb2listw(eire.nb), eire.df$A)
summary(lA)
moran.test(spNamedVec("A", eire.df), nb2listw(eire.nb))
geary.test(spNamedVec("A", eire.df), nb2listw(eire.nb))
cor(lA, eire.df$A)
moran.plot(spNamedVec("A", eire.df), nb2listw(eire.nb),
 labels=rownames(eire.df))
A.lm <- lm(A ~ towns + pale, data=eire.df)
summary(A.lm)
res <- residuals(A.lm)
brks <- c(min(res),-2,-1,0,1,2,max(res))
cols <- rev(cm.colors(6))
plot(eire.polys.utm, col=cols[findInterval(res, brks)], forcefill=FALSE)
title(main="Regression residuals")
legend(x=c(-50, 70), y=c(6120, 6050), legend=leglabs(brks), fill=cols,
  bty="n")
lm.morantest(A.lm, nb2listw(eire.nb))
lm.morantest.sad(A.lm, nb2listw(eire.nb))
lm.LMtests(A.lm, nb2listw(eire.nb), test="LMerr")
brks <- round(fivenum(eire.df$OWNCONS), digits=2)
cols <- grey(4:1/5)
plot(eire.polys.utm,
 col=cols[findInterval(eire.df$OWNCONS, brks)], forcefill=FALSE)
title(main="Percentage own consumption of agricultural produce")
legend(x=c(-50, 70), y=c(6120, 6050), legend=leglabs(brks),
  fill=cols, bty="n")
moran.plot(spNamedVec("OWNCONS", eire.df), nb2listw(eire.nb))
moran.test(spNamedVec("OWNCONS", eire.df), nb2listw(eire.nb))
e.lm <- lm(OWNCONS ~ ROADACC, data=eire.df)
res <- residuals(e.lm)
brks <- c(min(res),-2,-1,0,1,2,max(res))
cols <- rev(cm.colors(6))
plot(eire.polys.utm, col=cols[findInterval(res, brks)], forcefill=FALSE)
title(main="Regression residuals")
legend(x=c(-50, 70), y=c(6120, 6050), legend=leglabs(brks), fill=cm.colors(6),
  bty="n")
lm.morantest(e.lm, nb2listw(eire.nb))
lm.morantest.sad(e.lm, nb2listw(eire.nb))
lm.LMtests(e.lm, nb2listw(eire.nb), test="LMerr")
print(localmoran.sad(e.lm, eire.nb, select=1:nrow(eire.df)))



