### Name: moran.test
### Title: Moran's I test for spatial autocorrelation
### Aliases: moran.test
### Keywords: spatial

### ** Examples

data(oldcol)
moran.test(spNamedVec("CRIME", COL.OLD), nb2listw(COL.nb, style="W"))
moran.test(spNamedVec("CRIME", COL.OLD), nb2listw(COL.nb, style="B"))
moran.test(spNamedVec("CRIME", COL.OLD), nb2listw(COL.nb, style="C"))
moran.test(spNamedVec("CRIME", COL.OLD), nb2listw(COL.nb, style="S"))
moran.test(spNamedVec("CRIME", COL.OLD), nb2listw(COL.nb, style="W"),
 randomisation=FALSE)
colold.lags <- nblag(COL.nb, 3)
moran.test(spNamedVec("CRIME", COL.OLD), nb2listw(colold.lags[[2]],
 style="W"))
moran.test(spNamedVec("CRIME", COL.OLD), nb2listw(colold.lags[[3]],
 style="W"))
print(is.symmetric.nb(COL.nb))
COL.k4.nb <- knn2nb(knearneigh(coords.OLD, 4))
print(is.symmetric.nb(COL.k4.nb))
moran.test(spNamedVec("CRIME", COL.OLD), nb2listw(COL.k4.nb, style="W"))
moran.test(spNamedVec("CRIME", COL.OLD), nb2listw(COL.k4.nb, style="W"),
 randomisation=FALSE)
cat("Note: non-symmetric weights matrix, use listw2U()")
moran.test(spNamedVec("CRIME", COL.OLD), listw2U(nb2listw(COL.k4.nb,
 style="W")))
moran.test(spNamedVec("CRIME", COL.OLD), listw2U(nb2listw(COL.k4.nb,
 style="W")), randomisation=FALSE)
ranks <- rank(COL.OLD$CRIME)
names(ranks) <- rownames(COL.OLD)
moran.test(ranks, nb2listw(COL.nb, style="W"), rank=TRUE)
crime <- spNamedVec("CRIME", COL.OLD)
is.na(crime) <- sample(1:length(crime), 10)
res <- try(moran.test(crime, nb2listw(COL.nb, style="W"), na.action=na.fail))
res
moran.test(crime, nb2listw(COL.nb, style="W"), zero.policy=TRUE,
 na.action=na.omit)
moran.test(crime, nb2listw(COL.nb, style="W"), zero.policy=TRUE,
 na.action=na.exclude)
moran.test(crime, nb2listw(COL.nb, style="W"), na.action=na.pass)



