### Name: p.adjustSP
### Title: Adjust local association measures' p-values
### Aliases: p.adjustSP
### Keywords: spatial

### ** Examples

data(afcon)
oid <- order(afcon$id)
resG <- as.vector(localG(spNamedVec("totcon", afcon), nb2listw(include.self(paper.nb))))
non <- format.pval(pnorm(2*(abs(resG)), lower.tail=FALSE), 2)
bon <- format.pval(p.adjustSP(pnorm(2*(abs(resG)), lower.tail=FALSE), paper.nb, "bonferroni"), 2)
tot <- format.pval(p.adjust(pnorm(2*(abs(resG)), lower.tail=FALSE), "bonferroni", n=length(resG)), 2)
data.frame(resG, non, bon, tot, row.names=afcon$name)[oid,]



