### Name: sp.correlogram
### Title: Spatial correlogram
### Aliases: sp.correlogram plot.spcor print.spcor
### Keywords: spatial

### ** Examples

data(nc.sids)
ft.SID74 <- sqrt(1000)*(sqrt(nc.sids$SID74/nc.sids$BIR74) +
  sqrt((nc.sids$SID74+1)/nc.sids$BIR74))
tr.SIDS74 <- ft.SID74*sqrt(nc.sids$BIR74)
names(tr.SIDS74) <- rownames(nc.sids)
cspc <- sp.correlogram(ncCC89.nb, tr.SIDS74, order=8, method="corr",
 zero.policy=TRUE)
print(cspc)
plot(cspc)
Ispc <- sp.correlogram(ncCC89.nb, tr.SIDS74, order=8, method="I",
 zero.policy=TRUE)
print(Ispc)
print(Ispc, "bonferroni")
plot(Ispc)
drop.no.neighs <- !(1:length(ncCC89.nb) %in% which(card(ncCC89.nb) == 0))
sub.ncCC89.nb <- subset(ncCC89.nb, drop.no.neighs)
plot(sp.correlogram(sub.ncCC89.nb, subset(tr.SIDS74,  drop.no.neighs),
 order=8, method="corr"))



