### Name: spautolm
### Title: Spatial conditional and simultaneous autoregression model
###   estimation
### Aliases: spautolm residuals.spautolm deviance.spautolm coef.spautolm
###   fitted.spautolm print.spautolm summary.spautolm LR1.spautolm
###   logLik.spautolm print.summary.spautolm
### Keywords: spatial

### ** Examples

## Not run: 
##D esarI <- errorsarlm(ft.SID74 ~ 1, data=mdata, listw=sids.nhbr.listw, zero.policy=TRUE)
##D summary(esarI)
##D esarIa <- spautolm(ft.SID74 ~ 1, data=mdata, listw=sids.nhbr.listw, family="SAR")
##D summary(esarIa)
##D esarIV <- errorsarlm(ft.SID74 ~ ft.NWBIR74, data=mdata, listw=sids.nhbr.listw, zero.policy=TRUE)
##D summary(esarIV)
##D esarIVa <- spautolm(ft.SID74 ~ ft.NWBIR74, data=mdata, listw=sids.nhbr.listw, family="SAR")
##D summary(esarIVa)
##D esarIaw <- spautolm(ft.SID74 ~ 1, data=mdata, listw=sids.nhbr.listw, weights=mdata$BIR74, family="SAR")
##D summary(esarIaw)
##D esarIIaw <- spautolm(ft.SID74 ~ both - 1, data=mdata, listw=sids.nhbr.listw, weights=mdata$BIR74, family="SAR")
##D summary(esarIIaw)
##D esarIVaw <- spautolm(ft.SID74 ~ ft.NWBIR74, data=mdata, listw=sids.nhbr.listw, weights=mdata$BIR74, family="SAR")
##D summary(esarIVaw)
##D ecarIaw <- spautolm(ft.SID74 ~ 1, data=mdata.4, listw=sids.nhbr.listw.4, weights=mdata.4$BIR74, family="CAR")
##D summary(ecarIaw)
##D ecarIIaw <- spautolm(ft.SID74 ~ both - 1, data=mdata.4, listw=sids.nhbr.listw.4, weights=mdata.4$BIR74, family="CAR")
##D summary(ecarIIaw)
##D ecarIVaw <- spautolm(ft.SID74 ~ ft.NWBIR74, data=mdata.4, listw=sids.nhbr.listw.4, weights=mdata.4$BIR74, family="CAR")
##D summary(ecarIVaw)
##D nc_LL$fitIV <- append(fitted.values(ecarIVaw), NA, outl-1)
##D spplot(nc_LL, c("fitIV"), cuts=12) # Cressie 1993, p. 565
## End(Not run)
data(NY_data)
lm0 <- lm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata)
summary(lm0)
lm0w <- lm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata, weights=POP8)
summary(lm0w)
esar0 <- errorsarlm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata, listw=listw_NY)
summary(esar0)
esar1f <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata, listw=listw_NY, family="SAR", method="full")
summary(esar1f)
esar1s <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata, listw=listw_NY, family="SAR", method="SparseM")
summary(esar1s)
esar1wf <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata, listw=listw_NY, weights=nydata$POP8, family="SAR", method="full")
summary(esar1wf)
esar1ws <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata, listw=listw_NY, weights=nydata$POP8, family="SAR", method="SparseM")
summary(esar1ws)
ecar1f <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata, listw=listw_NY, family="CAR", method="full")
summary(ecar1f)
ecar1s <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata, listw=listw_NY, family="CAR", method="SparseM")
summary(ecar1s)
ecar1wf <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata, listw=listw_NY, weights=nydata$POP8, family="CAR", method="full")
summary(ecar1wf)
ecar1ws <- spautolm(Z ~ PEXPOSURE + PCTAGE65P + PCTOWNHOME, data=nydata, listw=listw_NY, weights=nydata$POP8, family="CAR", method="SparseM")
summary(ecar1ws)
data(oldcol)
COL.errW.eig <- errorsarlm(CRIME ~ INC + HOVAL, data=COL.OLD, nb2listw(COL.nb, style="W"))
summary(COL.errW.eig)
COL.errW.sar <- spautolm(CRIME ~ INC + HOVAL, data=COL.OLD, nb2listw(COL.nb, style="W"))
summary(COL.errW.sar)



