### Name: survdiffr
### Title: Test median survival differences (or other quantile)
### Aliases: survdiffr
### Keywords: survival

### ** Examples


data(colon)

#We will compare the median survival time for three dukes stages
fit<-survdiffr(Survr(hc,time,event)~as.factor(dukes),data=colon,q=0.5)
boot.ci(fit$"1")
boot.ci(fit$"2")
boot.ci(fit$"3")

# 75th quantile of survival function
fit<-survdiffr(Survr(hc,time,event)~as.factor(dukes),data=colon,q=0.75)
# bootstrap percentile confidence interval
quantile(fit$"1"$t,c(0.025,0.975))
quantile(fit$"2"$t,c(0.025,0.975))
quantile(fit$"3"$t,c(0.025,0.975))

# We can execute this if there is none Inf value
# boot.ci(fit$"1")
# boot.ci(fit$"2")
# boot.ci(fit$"3")

#We can modify the bootstrap procedure modifiying boot.F parameter
fit<-survdiffr(Survr(hc,time,event)~as.factor(dukes),data=colon,q=0.5,boot.F="PSH")
# bootstrap percentile confidence interval
quantile(fit$"1"$t,c(0.025,0.975))
quantile(fit$"2"$t,c(0.025,0.975))
quantile(fit$"3"$t,c(0.025,0.975))




