### Name: survfitr
### Title: Compute a Survival Curve for Recurrent Event Data given a
###   covariate
### Aliases: survfitr
### Keywords: survival

### ** Examples

  data(colon)
  # fit a pena-strawderman-hollander and plot it
  fit<-survfitr(Survr(hc,time,event)~as.factor(dukes),data=colon,type="pena")
  plot(fit,ylim=c(0,1),xlim=c(0,2000))
  # print the survival estimators
  fit
  summary(fit)

  # fit a MLE Frailty and plot it (in this case do not show s.e.)
  fit<-survfitr(Survr(hc,time,event)~as.factor(dukes),data=colon,type="MLE")
  plot(fit)
  # print the survival estimators
  fit
  summary(fit)




