### Name: TmixDist
### Title: Distribution of a linear combination of independent Student's
###   t-variables
### Aliases: tdist
### Keywords: distribution

### ** Examples

# Plot the cdf of the random variable T = t_1 + 2*t_2 + 3*t_3 + 4*t_4 + Z,
# where Z is a random variable with standard normal distribution
# and t_1, t_2, t_3 and t_4 are random variables with Student's t distribution
# with 1, 2, 3 and 4 degrees of freedom. The random variables are assumed
# to be stochastically independent.

funx = numeric(0)
dff = c(1, 2, 3, 4, Inf)
lambda = c(1, 2, 3, 4, 1)
res = tdist(funx, dff, lambda, 1)
plot(res$xfun, res$yfun, type = 'l')

###
# Plot the pdf of the random variable T = ( Z + t_1 + t_10 )/3,
# where Z is a random variable with standard normal distribution
# and t_1 and t_10 are random variables with Student's t distribution
# with 1 and 10 degrees of freedom. The random variables are assumed
# to be stochastically independent.

funtype = 2
funx = numeric(0)
dff = c(Inf, 1, 10)
lambda = c(1, 1, 1) / 3
pts = 6
res = tdist(funx, dff, lambda, funtype, pts)
plot(res$xfun, res$yfun, type = 'l')

###
# Calculate the quantiles (for given probabilities 0.9, 0.95, 0.99)
# of the random variable  T = ( t_1 + Z )/2, where Z is a random variable
# with standard normal distribution and t_1 is a random variable
# with Student's t distribution with 1 degree of freedom. The random variables
# are assumed to be stochastically independent.

prob = c(0.9, 0.95, 0.99)
quantiles = tdist(prob, c(1, Inf), 1/2, 3)$yfun
cbind(prob, quantiles)

###
# Plot the characteristic function of the random variable T = t_1 + t_2 + t_3,
# where t_1, t_2, and t_3 are random variables with Student's t distribution
# with 1, 2, and 3 degrees of freedom. The random variables are assumed to be
# stochastically independent.

chftt = tdist(numeric(0), c(1, 2, 3), c(1, 1, 1), 4)
chf = chftt[[1]]
tt = chftt[[2]]
plot(tt, chf, type = 'l')



