### Name: TmixDist
### Title: Distribution of a linear combination of independent Student's
###   t-variables
### Aliases: ctdist dtdist ptdist qtdist rtdist
### Keywords: distribution

### ** Examples

# Plot the characteristic function of the random variable T = t_1 + t_2 + t_3,
# where t_1, t_2, and t_3 are random variables with Student's t distribution
# with 1, 2, and 3 degrees of freedom. The random variables are assumed to be
# stochastically independent.

tt = c(seq(0,.1,,100), seq(.1,7,,200))
chf = ctdist(tt, c(1, 2, 3), c(1, 1, 1))
plot(tt, chf, type = 'l')

###
# Plot the pdf of the random variable T = ( Z + t_1 + t_10 )/3,
# where Z is a random variable with standard normal distribution
# and t_1 and t_10 are random variables with Student's t distribution
# with 1 and 10 degrees of freedom. The random variables are assumed
# to be stochastically independent.

dff = c(Inf, 1, 10)
lambda = c(1, 1, 1) / 3
x = seq(-4,4,,100)
pdf = dtdist(x, dff, lambda, 6)
plot(x, pdf, type = 'l')

###
# Plot the cdf of the random variable T = t_1 + 2*t_2 + 3*t_3 + 4*t_4 + Z,
# where Z is a random variable with standard normal distribution
# and t_1, t_2, t_3 and t_4 are random variables with Student's t distribution
# with 1, 2, 3 and 4 degrees of freedom. The random variables are assumed
# to be stochastically independent.

dff = c(1, 2, 3, 4, Inf)
lambda = c(1, 2, 3, 4, 1)
x = seq(-36,36,,200)
cdf = ptdist(x, dff, lambda)
plot(x, cdf, type = 'l')

###
# Calculate the quantiles (for given probabilities 0.9, 0.95, 0.99)
# of the random variable  T = ( t_1 + Z )/2, where Z is a random variable
# with standard normal distribution and t_1 is a random variable
# with Student's t distribution with 1 degree of freedom. The random variables
# are assumed to be stochastically independent.

prob = c(0.9, 0.95, 0.99)
quantiles = qtdist(prob, c(1, Inf), 1/2, 3)
cbind(prob, quantiles)

###
# Generate 1000 realization of the random variable  T = ( t_3 + t_5 + Z )/3,
# where Z is a random variable with standard normal distribution and t_3 and t_5
# are a random variable with Student's t distribution with 3 and 5 degrees
# of freedom. The random variables are assumed to be stochastically independent.

r = rtdist(1000, c(3, 5, Inf), 1/3)

# Plot the binned kernel density estimate of the probability density of the
# generated data by 'bdke' procedure and compare with true density (red line).

library(KernSmooth)
est <- bkde(r, bandwidth=0.25)
plot(est, ylim = c(-0, .6), type="l")
lines(est$x,dtdist(est$x, c(3, 5, Inf), 1/3), col = 'red')



