### Name: urn
### Title: Repeated Sampling Without Replacement
### Aliases: urn sampleu refill.urn
### Keywords: datagen distribution

### ** Examples


library(urn)

# Create urn with 3 items
u<-urn(list(1,2,3))

# custom print and summary methods
print(u )
summary(u)

# draw 2 samples from the urn
sampleu(u,2)
# can't sample more items than in the urn, without refilling:
# sampleu(u,2)
sum(u)
sampleu(u,1)
# refill
refill.urn(u)  
# Create an urn with 100010 items of two types in ~51:49 proportions
ub<-urn(c(51006,49004))
summary(ub)

# take ten draws each of 10001 items
rep<-replicate(10, table(sampleu(ub,10001)), simplify=TRUE)
print(rep)

# should equal 51006
sum(rep[1,])




