### Name: Mdates
### Title: Determine the Location in the Sample of a Date and vice versa
### Aliases: Mdates
### Keywords: ts

### ** Examples

    ## Mdates
    data(AirPassengers)
    ## Which date is related to the 12th observation?
    out1 <- Mdates(AirPassengers, 12)
    out1
    out1@Myso
    ## Where is located the observation in 1959.2
    out2 <- Mdates(AirPassengers, c(1959,2))
    out2
    ## Beyond the sample.
    Mdates(AirPassengers, 150)
    Mdates(AirPassengers, c(1970,2))

    ## Which is the next date after the 12th observation?
    stepdate(as.vdate(AirPassengers, yso=12), step=1)
  


