### Name: vabayelMix
### Title: Variational Bayesian Gaussian Mixture Model
### Aliases: vabayelMix
### Keywords: cluster

### ** Examples

NsTot <- 100; 
Nspg <- 50;
Ng <- 2;
deg.idx <- 1 ;
data <- matrix( nrow=NsTot, ncol=Ng);
for( s in 1:Nspg ){
  data[s,] <- rnorm(Ng,0,0.25);
}
for( s in (Nspg+1):NsTot){
  data[s,] <- rnorm(Ng,0,0.25);
  data[s,deg.idx] <- rnorm(1,2,0.25);
}
types.idx <- c(rep(1,50),rep(2,50));
useprior.l <- UseBasicPrior(data,rep(1,4));
vbmix <- vabayelMix(data, prior=NA, Ncat=4, nruns=10, npick=2,MaxIt=500, conv.tol=0.001, nCVconv=10);
# or could use
# vbmix <- vabayelMix(data, prior=useprior.l, Ncat=4, nruns=10, npick=2,MaxIt=500, conv.tol=0.001, nCVconv=10);
plot(1:NsTot,vbmix$wcl[1,],type="h",col=types.idx);



