### Name: ordihull
### Title: Add Graphical Items to Ordination Diagrams
### Aliases: ordihull ordiarrows ordisegments ordigrid ordispider
###   ordiellipse ordicluster ordispantree weights.cca weights.rda
###   weights.decorana
### Keywords: aplot

### ** Examples

data(dune)
data(dune.env)
mod <- cca(dune ~ Moisture, dune.env)
attach(dune.env)
plot(mod, type="n")
ordihull(mod, Moisture)
ordispider(mod, col="red")
plot(mod, type = "p", display="sites")
ordicluster(mod, hclust(vegdist(dune)), prune=3, col = "blue")
# The following is not executed automatically because it needs
# a non-standard library `ellipse'. 
## Not run: 
##D ordiellipse(mod, Moisture, kind="se", level=0.95, lwd=2, col="blue")
## End(Not run)



