### Name: ordiplot
### Title: Alternative plot and identify Functions for Ordination
### Aliases: ordiplot identify.ordiplot scores.ordiplot points.ordiplot
###   text.ordiplot
### Keywords: hplot iplot aplot

### ** Examples

# Draw a cute NMDS plot from a non-vegan ordinatin (isoMDS).
# Function metaMDS would be an easier alternative.
data(dune)
dune.dis <- vegdist(wisconsin(dune))
library(MASS)
dune.mds <- isoMDS(dune.dis)
dune.mds <- postMDS(dune.mds, dune.dis)
dune.mds$species <- wascores(dune.mds$points, dune, expand = TRUE)
fig <- ordiplot(dune.mds, type = "none")
points(fig, "sites", pch=21, col="red", bg="yellow")
text(fig, "species", col="blue", cex=0.9)
# Default plot of the previous using identify to label selected points
## Not run: 
##D fig <- ordiplot(dune.mds)
##D identify(fig, "spec")
## End(Not run)




