### Name: procrustes
### Title: Procrustes Rotation of Two Configurations
### Aliases: procrustes print.procrustes summary.procrustes
###   print.summary.procrustes plot.procrustes points.procrustes
###   lines.procrustes residuals.procrustes fitted.procrustes protest
###   print.protest
### Keywords: multivariate htest

### ** Examples

data(varespec)
vare.dist <- vegdist(wisconsin(varespec))
library(MASS)  ## isoMDS
mds.null <- isoMDS(vare.dist, tol=1e-7)
mds.alt <- isoMDS(vare.dist, initMDS(vare.dist), maxit=200, tol=1e-7)
vare.proc <- procrustes(mds.alt, mds.null)
vare.proc
summary(vare.proc)
plot(vare.proc)
plot(vare.proc, kind=2)
residuals(vare.proc)



