discrimination.plot       package:verification       R Documentation

_D_i_s_c_r_i_m_i_n_a_t_i_o_n  _p_l_o_t

_D_e_s_c_r_i_p_t_i_o_n:

     This function creates a plot of overlayed histograms.   In the
     context of verification, this is often used to compare the
     distribution of event and no-event forecasts.

_U_s_a_g_e:

     discrimination.plot(obs, pred, breaks = 11, main =
     "Comparison of Distributions", xlim = c(0,1), leg.txt = c("Model A",
     "Model B"), median = TRUE, ... )

_A_r_g_u_m_e_n_t_s:

     obs: A binary observation (coded {0, 1 } ).

    pred: A vector of predictions.

  breaks: Number of breaks in the x-axis of the histogram.

    main: Title for plot.

    xlim: Range of histogram - x axis.

 leg.txt: Legend text.

  median: If TRUE, the median values for the event and the no-event
          will be vertically plotted.  This is intended as a
          non-paramtric indicator of the forecast's ability to
          discriminate.  If FALSE, these vertical lines will be
          surpressed.

     ...: Additional plotting options.

_A_u_t_h_o_r(_s):

     Matt Pocernich <pocernic@rap.ucar.edu>

_E_x_a_m_p_l_e_s:

      #  A sample forecast.  

      a<- rnorm(100, mean = -1); b<- rnorm(100, mean = 1)

      A<- cbind(rep(0,100), pnorm(a)); B<- cbind(rep(1,100), pnorm(b)) 

      dat<- rbind(A,B); dat<- as.data.frame(dat)
      names(dat)<- c("obs", "pred")

      discrimination.plot(dat$obs, dat$pred, main = "Sample Plot")
      

