### Name: plot.WCCSOM
### Title: Plot WCCSOM object
### Aliases: plot.WCCSOM
### Keywords: classif

### ** Examples

data(cepha)
gr <- somgrid(3, 3, "hexagonal")
set.seed(7)
x <- WCCSOM(cepha$patterns, grid=gr, trwidth=20, rlen=100)

par(mfrow=c(3,2))
plot(x, type="codes", main="Codebook vectors")
plot(x, type="changes", main="Convergence")
plot(x, type="counts", main="Mapping counts")
plot(x, type="quality", main="Mapping quality")
plot(x, type="mapping", main="Mapping", 
     labels=cepha$class.names, col=as.integer(factor(cepha$class.names)))
plot(x, type="mapping", main="Mapping",
     pchs=as.integer(factor(cepha$class.names)),
     col=as.integer(factor(cepha$class.names)))

obj1.wccs <- plot(x, type="property", obj=cepha$patterns[1,])
obj1.wccs

par(mfrow=c(1,2))
unit.dists <- unit.distances(x$grid, toroidal=FALSE)
plot(x, type="property", property=unit.dists[1,],
     main="Distances to unit 1", zlim=c(0,4))
unit.dists <- unit.distances(x$grid, toroidal=TRUE)
plot(x, type="property", property=unit.dists[1,],
     main="Toroidal distances to unit 1", zlim=c(0,4))



