mle.cp                  package:wle                  R Documentation

_M_a_l_l_o_w_s _C_p

_D_e_s_c_r_i_p_t_i_o_n:

     The Mallows Cp is evaluated for each submodel.

_U_s_a_g_e:

     mle.cp(formula, data=list(), model=TRUE, x=FALSE, 
            y=FALSE, var.full=0, contrasts=NULL, verbose=FALSE)

_A_r_g_u_m_e_n_t_s:

 formula: a symbolic description of the model to be fit. The details of
          model specification are given below.

    data: an optional data frame containing the variables in the model.
           By default the variables are taken from the environment
          which 'mle.cp' is called from.

model, x, y: logicals.  If 'TRUE' the corresponding components of the
          fit (the model frame, the model matrix, the response).

var.full: the value of variance to be used in the denominator of the
          Mallows Cp, if 0 the variance estimated from the full model
          is used.

contrasts: an optional list. See the 'contrasts.arg' of
          'model.matrix.default'.

 verbose: if 'TRUE' warnings are printed.

_D_e_t_a_i_l_s:

     Models for 'mle.cp' are specified symbolically.  A typical model
     has the form 'response ~ terms' where 'response' is the (numeric)
     response vector and 'terms' is a series of terms which specifies a
     linear predictor for 'response'.  A terms specification of the
     form 'first+second' indicates all the terms in 'first' together
     with all the terms in 'second' with duplicates removed. A
     specification of the form 'first:second' indicates the the set of
     terms obtained by taking the interactions of all terms in 'first'
     with all terms in 'second'. The specification 'first*second'
     indicates the _cross_ of 'first' and 'second'.  This is the same
     as 'first+second+first:second'.

_V_a_l_u_e:

     'mle.cp' returns an object of 'class' '"mle.cp"'.

     The function 'summary' is used to obtain and print a summary of
     the results, only models below the bisector are reported. The
     generic accessor functions 'coefficients' and 'residuals' extract
     coefficients and residuals returned by 'mle.cp'. The object
     returned by 'mle.cp' are:

      cp: Mallows Cp for each submodels

coefficients: the parameters estimator, one row vector for eac
          submodel.

   scale: an estimation of the error scale, one value for each
          submodel.

residuals: the residuals from the estimated model, one column vector
          for each submodel.

    call: the match.call().

contrasts: 

 xlevels: 

   terms: the model frame.

   model: if 'model=TRUE' a matrix with first column the dependent
          variable and the remain column the explanatory variables for
          the full model.

       x: if 'x=TRUE' a matrix with the explanatory variables for the
          full model.

       y: if 'y=TRUE' a vector with the dependent variable.

    info: not well working yet, if 0 no error occurred.

_A_u_t_h_o_r(_s):

     Claudio Agostinelli

_R_e_f_e_r_e_n_c_e_s:

     Mallows, C.L., (1973) Some comments on Cp, _Technometrics_, 15,
     661-675.

_E_x_a_m_p_l_e_s:

     library(wle)

     data(hald)

     cor(hald)

     result <- mle.cp(y.hald~x.hald)

     summary(result)

     plot(result)

