### Name: wle.aic
### Title: Weighted Akaike Information Criterion
### Aliases: wle.aic
### Keywords: regression robust

### ** Examples

library(wle)

x.data <- c(runif(60,20,80),runif(5,73,78))
e.data <- rnorm(65,0,0.6)
y.data <- 8*log(x.data+1)+e.data
y.data[61:65] <- y.data[61:65]-4
z.data <- c(rep(0,60),rep(1,5))

plot(x.data,y.data,xlab="X",ylab="Y")

xx.data <- cbind(x.data,x.data^2,x.data^3,log(x.data+1))
colnames(xx.data) <- c("X","X^2","X^3","log(X+1)")

result <- wle.aic(y.data~xx.data,boot=10,group=10,num.sol=2)

summary(result)

result <- wle.aic(y.data~xx.data+z.data,boot=10,group=10,num.sol=2)

summary(result)




