### Name: wle.fracdiff
### Title: Fit Fractional Models to Time Series - Preliminary Version
### Aliases: wle.fracdiff
### Keywords: robust ts

### ** Examples

require(stats)
if (require(fracdiff)) {
    res <- fracdiff(Nile)
    res$d
}
set.seed(1234)
resw <- wle.fracdiff(Nile, M=100, include.mean=TRUE, lower=0.01, upper=0.96, group=20)
resw$d
resw$sigma2
resw$x.mean

x <- Nile
x[50] <- x[50]+4*sd(x)
if (require(fracdiff)) {
    res <- fracdiff(x)
    res$d
}

set.seed(1234)
resw <- wle.fracdiff(x, M=100, include.mean=TRUE, lower=0.01, upper=0.96, group=40)
resw$d
resw$sigma2
resw$x.mean
resw$ao.position




