### Name: wle.lm.summaries
### Title: Accessing Linear Model Fits for wle.lm
### Aliases: coef.wle.lm formula.wle.lm fitted.wle.lm model.frame.wle.lm
###   summary.wle.lm summary.wle.lm.root weights.wle.lm print.wle.lm
###   print.summary.wle.lm print.summary.wle.lm.root
### Keywords: robust regression

### ** Examples

library(wle)
# You can find this data set in:
# Hawkins, D.M., Bradu, D., and Kass, G.V. (1984). 
# Location of several outliers in multiple regression data using
# elemental sets. Technometrics, 26, 197-208.
#
data(artificial)

result <- wle.lm(y.artificial~x.artificial,boot=40,group=6,num.sol=3)

#summary only for the first root
summary(result,root=1)
#summary for all the roots
summary(result,root="ALL")



